// Cause warning on non-ANSI compilers
#if !defined(DONE_GIF_TYPES_H) && !defined(DONE_MTYPES_H)
#define DONE_GIF_TYPES_H "_$Id: gif_type.h,v 1.2 2012/02/12 01:19:26 roger Exp $_";
/*
 * Various functions which don't exist across multiple OSs
 * Supports Win32 (>MSC8), DOS/Win32 (<MSC7), DJGPP (DOS/Win95+), OpenBSD/Linux/CygWin
 *
 * Copyright (C) 2014 Roger Walker - smallgif.com
 * Commercial and Non-commercial is allowed, for this or it's derivatives providing you credit me
 * In the "About box" or documentation you should mention "The gif image file functions are based on work by Roger@smallgif.com"
 */

/****************************** Common Headers *****************************/
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <fcntl.h>
#ifdef _MSC_VER
	#include <io.h>
	#include <share.h>
	#include <process.h>
	#include <memory.h>
	#include <sys/types.h>
#endif
#include <sys/stat.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

/********************* local headers, typedefs & Consts ********************/

// Define BYTE, WORD and DWORD types
typedef unsigned char	BYTE;
typedef unsigned short	WORD;
typedef unsigned long	DWORD;

// Check if SET_BOOL is defined, to allow for other definitions of true and false
#ifndef SET_BOOL
	// Define bool and SET_BOOL
	#ifndef __cplusplus
		typedef signed char bool;
		#define false	((bool)(0))
		#define true	((bool)(!0))
	#endif
	#define SET_BOOL(q) (bool)((q) ? true : false)
#endif

// Define pack attrib if we can
#ifndef PACK_ATTRIB
	#ifdef _MSC_VER
		// If MSC then set pack attrib to blank (and have to use pragmas)
		#define PACK_ATTRIB
		#define PACK_USEPRAGMA
	#else
		// If GCC or other then use pack attrib
		#define PACK_ATTRIB __attribute__((packed))
		#undef PACK_USEPRAGMA
	#endif
#endif

// Definitions for common items
#if defined(_MSC_VER)
	// MSC Win32
	// Non MS systems don't have it so we can't include it
	#if _MSC_VER>=1000
		#pragma warning(push,3)
		// 3 is highest warnings for conio !
		#include <conio.h>
		#pragma warning(pop)
		#define CDEFAULT_CALLING
	#else
		#define MSC_16BIT_VER
		#include <conio.h>
		#include <sys/types.h>
		#define CDEFAULT_CALLING _FAR_ _cdecl
		#define main(a,v) CDECL main(a,v)
	#endif
	#if _MSC_VER>=1400
		#define _MSC_VS_SECURE
		#include <ctype.h>
		#pragma warning(disable:4996)
//		#ifndef _CRT_SECURE_NO_DEPRECATE
//			#error You need to recompile with /D_CRT_SECURE_NO_DEPRECATE
//		#endif

		// Sort out crappy handing of foreign chars in 8-bit mode, '' causes crash!
		#define orig_isalpha(c) isalpha(c)
		#define isalpha(c) orig_isalpha(((unsigned char)c)&0xFF)

		#define orig_isupper(c) isupper(c)
		#define isupper(c) orig_isupper(((unsigned char)c)&0xFF)

		#define orig_islower(c) islower(c)
		#define islower(c) orig_islower(((unsigned char)c)&0xFF)

		#define orig_isdigit(c) isdigit(c)
		#define isdigit(c) orig_isdigit(((unsigned char)c)&0xFF)

		#define orig_isxdigit(c) isxdigit(c)
		#define isxdigit(c) orig_isxdigit(((unsigned char)c)&0xFF)

		#define orig_isspace(c) isspace(c)
		#define isspace(c) orig_isspace(((unsigned char)c)&0xFF)

		#define orig_ispunct(c) ispunct(c)
		#define ispunct(c) orig_ispunct(((unsigned char)c)&0xFF)

		#define orig_isalnum(c) isalnum(c)
		#define isalnum(c) orig_isalnum(((unsigned char)c)&0xFF)

		#define orig_isprint(c) isprint(c)
		#define isprint(c) orig_isprint(((unsigned char)c)&0xFF)

		#define orig_isgraph(c) isgraph(c)
		#define isgraph(c) orig_isgraph(((unsigned char)c)&0xFF)

		#define orig_iscntrl(c) iscntrl(c)
		#define iscntrl(c) orig_iscntrl(((unsigned char)c)&0xFF)

		#define orig___isascii(c) __isascii(c)
		#undef __isascii
		#define __isascii(c) orig___isascii(((unsigned char)c)&0xFF)

		#define orig___iscsymf(c) __iscsymf(c)
		#undef __iscsymf
		#define __iscsymf(c) orig___iscsymf(((unsigned char)c)&0xFF)

		#define orig___iscsym(c) __iscsym(c)
		#undef __iscsym
		#define __iscsym(c) orig___iscsym(((unsigned char)c)&0xFF)

		#define orig_toupper(c) toupper(c)
		#define toupper(c) orig_toupper(((unsigned char)c)&0xFF)

		#define orig__toupper(c) _toupper(c)
		#undef _toupper
		#define _toupper(c) orig__toupper(((unsigned char)c)&0xFF)

		#define orig_tolower(c) tolower(c)
		#define tolower(c) orig_tolower(((unsigned char)c)&0xFF)

		#define orig__tolower(c) _tolower(c)
		#undef _tolower
		#define _tolower(c) orig__tolower(((unsigned char)c)&0xFF)

		#define orig___toascii(c) __toascii(c)
		#undef __toascii
		#define __toascii(c) orig___toascii(((unsigned char)c)&0xFF)

	#endif
	// Definitions for common items
	#ifndef CDECL
		#define CDECL _cdecl
	#endif
	#define inline __inline
	#ifndef INLINE
		#define INLINE __inline
	#endif
	#ifndef P_WAIT
		#define P_WAIT _P_WAIT
	#endif
	#define cDirSep '\\'
#elif defined(__DJGPP__)
	// DJGPP DOS/Windows
	// Non MS systems don't have it so we can't include it
	#include <io.h>
	#define CDECL
	#define INLINE inline
	#define P_WAIT _P_WAIT
	#define CDEFAULT_CALLING
	#define cDirSep '\\'
#else
	// OpenBSD etc.
	#include <unistd.h>
	#define _UNIX
	#if !defined(__CYGWIN__)
		// Already defined for cygwin
		#define O_BINARY 0
	#endif
	// Definitions for common items
	#define CDECL
	#define INLINE inline
	#define P_WAIT 1
	#define CDEFAULT_CALLING
	#define cDirSep '/'
#endif

#if defined(BYTE_ORDER) && defined(BIG_ENDIAN) && BYTE_ORDER == BIG_ENDIAN
#define IS_BIG_ENDIAN
#define BE_WORD(w) ((((w)&0xFF)<<8) | (((w)>>8)&0xFF))
#define BE_DWORD(d) ( (((d)&0xFF)<<24) || (((d)&0xFF00)<<8) | (((d)>>8)&0xFF00 | (((d)>>24)&0xFF)) )
#endif

/********************** Public function definitions *************************/
#if defined(_MSC_VER)
	#pragma warning(disable:4273)
	#pragma warning(disable:4996)
	/************************** Windows macros *******************************/
	#define sleep(s)		_sleep(s)
#elif defined(__DJGPP__)
	/*************************** DJGPP macro ********************************/
	// Re-definitions for equivilant functions
	#define lstat(path,buf) stat(path,buf)
#elif defined(_UNIX)
	/**************************** UNIX macros ********************************/
	// Definitions for new items
	#define ltoa(v,d,b) itoa(v,d,b)

	#if !defined(__CYGWIN__)
		#define strnicmp(a,b,l) strncasecmp(a,b,l)
		#define stricmp(a,b) strcasecmp(a,b)
	#endif

	#if !defined(CURSES)
		// Re-definitions for equivilant functions, if we don't have CURSES included
		#define getch() getchar()
	#endif
#endif

char * CDEFAULT_CALLING strupr(char *str);
char * CDEFAULT_CALLING strlwr(char *str);

long CDEFAULT_CALLING filelength(int fh);
off_t CDEFAULT_CALLING tell(int fh);	// DJGPP needs off_t
int CDEFAULT_CALLING eof(int fh);

char *CDEFAULT_CALLING itoa(int val,char *dest,int base);

/*************************** common macros ******************************/
#define UNUSED(var) (void)(var)

// Evaluates to the number of entries in an array
#define NENTRIES(var) (sizeof(var)/sizeof(var[0]))

// If step = 2, val 0->2, 1->2, 2->2, 3->4, 4->4, 5->6 etc.
#define ROUNDUP(val,step) ((val)+(((step)-1)-((val)-1)%step))

// Evaluates to the byte offset of member m from the base of type t
#define STRUCT_OFFSET(t,m) ( (char *)(&((t *)NULL)->m) - (char *)NULL )

#ifndef min
#define min(a,b) ((a)<=(b) ? (a) : (b))
#endif

#ifndef max
#define max(a,b) ((a)>=(b) ? (a) : (b))
#endif


	/************************ functions definitions ****************************/
#if !defined(NO_FUNCTIONS)
#if defined(_MSC_VER)
	/************************** Windows functions *******************************/
	#if _MSC_VER>=1000
		// Don't warn about unused static functions
		#pragma warning(disable:4505)
	#endif
#endif

#if defined(_UNIX)
	/**************************** UNIX functions ********************************/
	#include <ctype.h>

	char *itoa(int iVal,char *pDestStr,int iBase)
	{	snprintf(pDestStr,12,(iBase==16) ? "%X" : "%u",iVal);
		return pDestStr;
	}

	long filelength(int fh)
	{	struct stat buf;
		if (fstat( fh, &buf )!=0) return 0;
		return buf.st_size;
	}

	off_t tell(int fh)
	{	return lseek(fh,0,SEEK_CUR);
	}

	int eof(int fh)
	{	return (tell(fh)==filelength(fh)) ? 1 : 0;
	}
#endif

/************************** common functions *******************************/
#if !defined(__CYGWIN__) && !defined(_MSC_VER)
	char *strupr(char *str)
	{	char *pOld=str;
		for (; *str!='\0' ; str++)
			if (islower(*str)) *str=(char)toupper(*str);
		return pOld;
	}

	char *strlwr(char *str)
	{	char *pOld=str;
		for (; *str!='\0' ; str++)
			if (isupper(*str)) *str=(char)tolower(*str);
		return pOld;
	}
#endif

#ifndef _MSC_VS_SECURE
	#include <assert.h>
	#ifdef DEBUG
		void CDEFAULT_CALLING memcpy_s_assert(const char *pFile,unsigned uLine,void *pDest,const unsigned uDestSize,const void *pSrc,unsigned uSrcSize)
		{	if (uDestSize<uSrcSize)
			{	fprintf(stderr,"Error %s %u: %u<%u!\n",pFile,uLine,uDestSize,uSrcSize);
				exit(250);
			}
			memcpy(pDest,pSrc,uSrcSize);
		}
	#else
		void CDEFAULT_CALLING memcpy_s(void *pDest,const unsigned uDestSize,const void *pSrc,unsigned uSrcSize)
		{	assert(uDestSize>=uSrcSize);
			memcpy(pDest,pSrc,uSrcSize);
		}
	#endif
#endif

#endif // !defined(NO_FUNCTIONS)

#ifdef __cplusplus
}
#endif

#endif // DONE_GIF_TYPES_H
